uniform sampler2D tex;
uniform float VT_alpha_strength;
uniform float VT_alpha_sharpness;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
	vec4 color = gl_Color;
	vec4 texColor = texture2D(tex, uv.xy);
	float dr = (color.r-texColor.r);
	float dg = (color.g-texColor.g);
	float db = (color.b-texColor.b);
	float d = (dr*dr + dg*dg + db*db) / 3.0;
	float a = clamp((d-VT_alpha_strength) * VT_alpha_sharpness, 0.0, 1.0);
	texColor.a = texColor.a * color.a * a;
	gl_FragColor = texColor;
}
